#Requires AutoHotkey v1.1.35+
#Include %A_ScriptDir%\Acc.ahk
#Include %A_ScriptDir%\JEEAhk1FC.ahk

Sleep(2000)
SoundBeep()
hWnd := WinExist("A")
A_Clipboard := JEE_AccGetTextAll(hWnd, "`r`n") "`r`n"
MsgBox("done")
return

JEE_AccGetTextAll(hWndOrAcc:=0, vSep:="`n", vIndent:="`t", vOpt:="")
{
	;local
	static vIsV1 := (InStr(A_AhkVersion, "1.") == 1)
	vLimN := vLimV := 100
	vCheckType := 0
	vDoGetPos := vDoGetRoleState := 0
	vNeedleType := 0
	vOpt := StrReplace(vOpt, "`t", " ")
	Loop Parse, vOpt, % " "
	{
		vTemp := A_LoopField
		if JEE_StrStarts(vTemp, "n")
			vLimN := 0 + SubStr(vTemp, 2)
		else if JEE_StrStarts(vTemp, "v")
			vLimV := 0 + SubStr(vTemp, 2)
		else if (vTemp = "p")
			vDoGetPos := 1
		else if (vTemp = "h")
			vDoGetRoleState := 1
		else if JEE_StrStarts(vTemp, "s")
		{
			vNeedleType := 0 + SubStr(vTemp, 2)
			vCheckType := 1
		}
		else if JEE_StrStarts(vTemp, "!s")
		{
			vNeedleType := 0 + SubStr(vTemp, 3)
			vCheckType := 2
		}
		else if JEE_StrStarts(vTemp, "r")
		{
			vNeedleType := 0 + SubStr(vTemp, 2)
			vCheckType := 3
		}
		else if JEE_StrStarts(vTemp, "!r")
		{
			vNeedleType := 0 + SubStr(vTemp, 3)
			vCheckType := 4
		}
	}
	vDoLeast := !vDoGetPos && !vDoGetRoleState

	;OBJID_WINDOW := 0
	if IsObject(hWndOrAcc)
		oStack := [[hWndOrAcc]]
	else
		oStack := [[Acc_ObjectFromWindow(hWndOrAcc, 0x0)]]
	oPos := [1]
	vLevel := 1
	VarSetStrCapacity(vIsV1?vOutput:&vOutput, 1000000)

	vIsErr := 0
	Loop
	{
		if !vLevel
			break
		if !oStack[vLevel].HasKey(oPos[vLevel])
		{
			oStack.Pop()
			oPos.Pop()
			vLevel--
			if !vLevel
				break
			oPos[vLevel]++
			continue
		}
		oKey := oStack[vLevel][oPos[vLevel]]

		vName := ""
		vValue := ""
		vRoleText := ""
		if IsObject(oKey)
		{
			try vRoleText := Acc_GetRoleText(oKey.accRole[0])
			try vName := oKey.accName[0]
			try vValue := oKey.accValue[0]
		}
		else
		{
			oParent := oStack[vLevel-1][oPos[vLevel-1]]
			vChildID := IsObject(oKey) ? 0 : oPos[vLevel]
			try vRoleText := Acc_GetRoleText(oParent.accRole[vChildID])
			try vName := oParent.accName[vChildID]
			try vValue := oParent.accValue[vChildID]
		}
		if (StrLen(vName) > vLimN)
			vName := SubStr(vName, 1, vLimN) "..."
		if (StrLen(vValue) > vLimV)
			vValue := SubStr(vValue, 1, vLimV) "..."
		vName := RegExReplace(vName, "[`r`n]", " ")
		vValue := RegExReplace(vValue, "[`r`n]", " ")

		vAccPath := ""
		if IsObject(oKey)
		{
			Loop % vLevel - 1
				vAccPath .= (A_Index = 1 ? "" : ".") oPos[A_Index+1]
		}
		else
		{
			Loop % vLevel - 2
				vAccPath .= (A_Index = 1 ? "" : ".") oPos[A_Index+1]
			vAccPath .= " c" oPos[vLevel]
		}

		;==========

		;if option set, filter by state/role:
		vIsMatch := 0
		if (vCheckType == 0)
			vIsMatch := 1
		else if (vCheckType == 1)
		|| (vCheckType == 2)
		{
			if IsObject(oKey)
				vState := oKey.accState[0]
			else
				vState := oParent.accState[vChildID]
			if (vCheckType == 1) && (vState & vNeedleType = vNeedleType)
				vIsMatch := 1
			else if (vCheckType == 2) && (vState & vNeedleType != vNeedleType)
				vIsMatch := 1
		}
		else if (vCheckType == 3)
		|| (vCheckType == 4)
		{
			if IsObject(oKey)
				vRole := oKey.accRole[0]
			else
				vRole := oParent.accRole[vChildID]
			if (vCheckType == 3) && (vRole & vNeedleType = vNeedleType)
				vIsMatch := 1
			else if (vCheckType == 4) && (vRole & vNeedleType != vNeedleType)
				vIsMatch := 1
		}

		;if option set, include element position/size:
		if vIsMatch
		{
			if vDoLeast
				vOutput .= vAccPath "`t" JEE_StrRept(vIndent, vLevel-1) vRoleText " [" vName "][" vValue "]" vSep
			else
			{
				vOutput .= vAccPath "`t" JEE_StrRept(vIndent, vLevel-1) vRoleText " [" vName "][" vValue "]"
				if vDoGetRoleState
				{
					if IsObject(oKey)
					{
						vState := oKey.accState[0]
						vRole := oKey.accRole[0]
					}
					else
					{
						try vState := oParent.accState[vChildID]
						catch
						{
							vRole := 0
							vIsErr := 1
						}
						try vRole := oParent.accRole[vChildID]
						catch
						{
							vState := 0
							vIsErr := 1
						}
					}
					vOutput .= Format("[0x{:02X}][0x{:08X}]", vRole, vState)
					if vIsErr
					{
						vOutput .= "[ERROR]"
						vIsErr := 0
					}
				}
				if vDoGetPos
				{
					vEltPos := ""
					if IsObject(oKey)
						Acc_Location(oKey, 0, vIsV1?vEltPos:&vEltPos)
					else
						Acc_Location(oParent, vChildID, vIsV1?vEltPos:&vEltPos)
					vOutput .= "[" vEltPos "]"
				}
				vOutput .= vSep
			}
		}

		;==========

		oChildren := Acc_Children(oKey)
		if !IsObject(oChildren) || !oChildren.Length()
			oPos[vLevel]++
		else
		{
			vLevel++
			oStack.Push(oChildren)
			oPos.Push(1)
		}
	}
	return SubStr(vOutput, 1, -StrLen(vSep))
}

;==================================================

;e.g. MsgBox(JEE_StrRept("abc_", 3))
JEE_StrRept(vText, vNum)
{
	local
	if IsNumber(vNum) && (vNum >= 0)
		return StrReplace(Format("{:" vNum "}", ""), " ", vText)
	throw Error("Parameter #2 is invalid.", -1)
}

;==================================================

JEE_StrStarts(vText, oNeedles, vCaseSen:=0)
{
	local
	if (oNeedles == "")
		throw Error("Parameter #2 is invalid.", -1)
	else if !IsObject(oNeedles)
		return !StrCompare(SubStr(vText, 1, StrLen(oNeedles)), oNeedles, vCaseSen)

	for vKey, vValue in oNeedles
	{
		if !StrCompare(SubStr(vText, 1, StrLen(vValue)), vValue, vCaseSen)
			return vKey
	}
	return 0
}

;==================================================
